package gov.va.med.mhv.usermgmt.service.impl;

import gov.va.med.mhv.usermgmt.bizobj.BusinessObjectFactory;
import gov.va.med.mhv.usermgmt.bizobj.DirectMessageAssembler;
import gov.va.med.mhv.usermgmt.bizobj.DirectMessageBO;
import gov.va.med.mhv.usermgmt.service.DirectMessageCollectionServiceResponse;
import gov.va.med.mhv.usermgmt.service.DirectMessageServiceResponse;
import gov.va.med.mhv.usermgmt.transfer.DirectMessage;
import java.lang.Long;
import java.lang.String;
import java.util.Collection;

import org.tigris.atlas.messages.DefaultMessage;

import gov.va.med.mhv.usermgmt.service.DirectMessageService;

/**
 * Service implementation class for the DirectMessage service
 * @see gov.va.med.mhv.usermgmt.service.DirectMessageService
 */
public class DirectMessageServiceImpl implements DirectMessageService {

	/**
	 * Execute the SaveDirectMessage service
	 * @see gov.va.med.mhv.usermgmt.service.DirectMessageService#SaveDirectMessage()
	 */
	public DirectMessageServiceResponse saveDirectMessage(DirectMessage directMessage) {
		DirectMessageServiceResponse response = new DirectMessageServiceResponse();
		
		try {
			DirectMessageBO bo = BusinessObjectFactory.createDirectMessageBO();
			bo.setDirectMessageValues(directMessage);
			bo.save();
			if( bo.getAllMessages( ).hasErrorMessages( ) ) {	     
	            response.getMessages( ).addMessages( bo.getAllMessages( ) );
	        }	
		} catch(Exception x) {
			DefaultMessage msg = new DefaultMessage();
			msg.addProperty(x.getLocalizedMessage());
			response.getMessages().addMessage(msg);
		}
		
		return response;
	}


	/**
	 * Execute the GetDirectMessagesByDirectMessageStatusAndUserProfileId service
	 * @see gov.va.med.mhv.usermgmt.service.DirectMessageService#GetDirectMessagesByDirectMessageStatusAndUserProfileId()
	 */
	public DirectMessageCollectionServiceResponse getDirectMessagesByDirectMessageStatusAndUserProfileId(Long userProfileId, String directMessageStatus) {
		DirectMessageCollectionServiceResponse response = new DirectMessageCollectionServiceResponse();
		Collection directMessages = null;
		
		try{
			directMessages = DirectMessageAssembler.getDirectMessageCollection(DirectMessageBO.getDirectMessagesByDirectMessageStatusAndUserProfileId(userProfileId, directMessageStatus));
		
		}
		catch(Exception x)
		{
			DefaultMessage msg = new DefaultMessage();
			msg.addProperty(x.getLocalizedMessage());
			response.getMessages().addMessage(msg);
		}
		response.addDirectMessages(directMessages);
		
		return response;
	}


	/**
	 * Execute the GetDirectMessagesByUserProfileId service
	 * @see gov.va.med.mhv.usermgmt.service.DirectMessageService#GetDirectMessagesByUserProfileId()
	 */
	public DirectMessageCollectionServiceResponse getDirectMessagesByUserProfileId(Long userProfileId) {
		DirectMessageCollectionServiceResponse response = new DirectMessageCollectionServiceResponse();
		Collection directMessages = null;
		
		try{
			directMessages = DirectMessageAssembler.getDirectMessageCollection(DirectMessageBO.getDirectMessagesByUserProfileId(userProfileId));
		
		}
		catch(Exception x)
		{
			DefaultMessage msg = new DefaultMessage();
			msg.addProperty(x.getLocalizedMessage());
			response.getMessages().addMessage(msg);
		}
		response.addDirectMessages(directMessages);
		
		return response;
	}

}